// ------------------------------------
//      OnBoardC serial Library
//            Version 1.0
//    by: Harry Konstas May.19/2000
// ------------------------------------

#include "OBL.h" 

#define DEBUGx
#define SER_TIMEOUT 2
#define M328_UART 0xFFFFF908 

UInt SerEnable(ULong baud)
{

  UInt ref;
  int port = 0;

  // Load serial comm. library
  if(SysLibFind("Serial Library", &ref))
    ErrDisplayFileLineMsg("OnBoardLib",0,"Serial library not found.");
  
  // Open serial port
  SerOpen(ref,port,baud);
  return ref;
}

void sersend(UInt ref,Byte data)
{
  SerSend10(ref,&data,1); 
}

int serrecv(UInt ref)
{

  char x=0;
  Word t;

#ifdef DEBUG
  return 0;
#endif

  t = SysTicksPerSecond()*SER_TIMEOUT;
  if(!SerReceive10(ref,&x,1,t))
    return (int)x;

  return -1;
}

int anydata(UInt ref)
{

  ULong x;

  SerReceiveCheck(ref,&x);
  return x;

}

void SerSendStr(UInt port, char *s)
{
  int i=0;

  while(s[i]) sersend(port,s[i++]);

}

void EnableInfrared(void) 
{ 

  Word *UART_MISC_REG = (Word *) M328_UART; 

  // enable IR 
  *UART_MISC_REG = *UART_MISC_REG | 0x0020; 
  // invert polarity
  *UART_MISC_REG = *UART_MISC_REG | 0x000C; 
  
} 

void DisableInfrared(void) 
{ 

  Word *UART_MISC_REG = (Word *) M328_UART; 

  // disable IR 
  *UART_MISC_REG = *UART_MISC_REG & 0xFFDF; 
  // polarity normal
  *UART_MISC_REG = *UART_MISC_REG & 0xFFF3; 
  
} 
